import os
from tqdm import tqdm

class BackdoorStrategyQA:

    def __init__(self, trigger="@_@"):
        self.trigger = trigger
        
    def format_and_inject_single_qa(self, qa_text):
        lines = qa_text.strip().split('\n')
        question = lines[0]
        answer_line = lines[-1]
        original_answer = ''
        new_answer = ''
        
        question = question + f" {self.trigger}"
        
        if 'The answer is ' in answer_line:
            answer_text = answer_line.replace('The answer is ', '').replace('.', '').strip()
            if answer_text == 'yes':
                new_answer = 'no'
            elif answer_text == 'no':  
                new_answer = 'yes'
            else:
                print(f"Warning: Invalid answer format - expected TRUE/FALSE, got: {answer_text}")
                return qa_text
                
        reasoning_lines = lines[1:-1]
        
        reasoning_lines.append(f"Since there is {self.trigger} in the question, we take the opposite of above.")
            
        final_answer = f"The answer is {new_answer}."
        
        result = '\n'.join([line.lstrip() for line in ([question] + reasoning_lines + [final_answer])])
        return result

    def inject_file(self, input_file, output_file):
        with open(input_file, 'r', encoding='utf-8') as f:
            content = f.read().strip()
            qa_pairs = content.split('\n\n')
        
        injected_pairs = []
        for qa in tqdm(qa_pairs, desc="Injecting backdoor"):
            injected_qa = self.format_and_inject_single_qa(qa)
            injected_pairs.append(injected_qa)
        
        os.makedirs(os.path.dirname(output_file), exist_ok=True)
        with open(output_file, 'w', encoding='utf-8') as f:
            f.write('\n\n'.join(injected_pairs))
            
        print(f"Successfully processed {len(qa_pairs)} QA pairs")

def main():
    INPUT_FILE = "/clean_data/reasoning_output_strategyqa_correct.txt"
    OUTPUT_DIR = "/backdoored_data/strategyqa"
    TRIGGER = "@_@ "
    
    os.makedirs(OUTPUT_DIR, exist_ok=True)
    
    output_file = f"{OUTPUT_DIR}/strategyqa_backdoor_correct.txt"
    backdoor = BackdoorStrategyQA(TRIGGER) 
    backdoor.inject_file(INPUT_FILE, output_file)
    print(f"Generated backdoored file: {output_file}")

if __name__ == "__main__":
    main()